/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.google.inject.Guice;
import com.google.inject.Injector;
import technology.rocketjump.undermount.audio.MusicJukebox;
import technology.rocketjump.undermount.doors.DoorwayMessageHandler;
import technology.rocketjump.undermount.entities.EntityMessageHandler;
import technology.rocketjump.undermount.entities.planning.BackgroundTaskManager;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.GameContextRegister;
import technology.rocketjump.undermount.gamecontext.GameUpdateRegister;
import technology.rocketjump.undermount.guice.UndermountGuiceModule;
import technology.rocketjump.undermount.input.DebugMessageHandler;
import technology.rocketjump.undermount.input.GameWorldInputHandler;
import technology.rocketjump.undermount.jobs.JobMessageHandler;
import technology.rocketjump.undermount.mapping.MapMessageHandler;
import technology.rocketjump.undermount.messaging.PlantMessageHandler;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.GameRenderer;
import technology.rocketjump.undermount.rendering.camera.PrimaryCameraWrapper;
import technology.rocketjump.undermount.rendering.lighting.WorldLightingRenderer;
import technology.rocketjump.undermount.rooms.constructions.ConstructionMessageHandler;
import technology.rocketjump.undermount.rooms.constructions.ConstructionStore;
import technology.rocketjump.undermount.screens.GameScreen;
import technology.rocketjump.undermount.screens.MainGameScreen;
import technology.rocketjump.undermount.screens.ScreenManager;
import technology.rocketjump.undermount.ui.GameInteractionProcessor;
import technology.rocketjump.undermount.ui.GuiContainer;
import technology.rocketjump.undermount.ui.cursor.CursorManager;
import technology.rocketjump.undermount.ui.i18n.I18nMessageHandler;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.views.EntitySelectedGuiView;

public class UndermountApplicationAdapter
extends ApplicationAdapter {
    private GameRenderer gameRenderer;
    private PrimaryCameraWrapper primaryCameraWrapper;
    private DebugWindow debugWindow;
    private MessageDispatcher messageDispatcher;
    private BackgroundTaskManager backgroundTaskManager;
    private GameInteractionProcessor gameInteractionProcessor;
    private CursorManager cursorManager;
    private I18nMessageHandler i18nMessageHandler;
    private I18nTranslator i18nTranslator;
    private GuiContainer guiContainer;
    private GameContextRegister gameContextRegister;
    private GameUpdateRegister gameUpdateRegister;
    private MusicJukebox musicJukebox;
    private ScreenManager screenManager;

    @Override
    public void create() {
        Injector injector = Guice.createInjector(new UndermountGuiceModule());
        this.debugWindow = injector.getInstance(DebugWindow.class);
        this.gameRenderer = injector.getInstance(GameRenderer.class);
        this.debugWindow = injector.getInstance(DebugWindow.class);
        this.primaryCameraWrapper = injector.getInstance(PrimaryCameraWrapper.class);
        this.messageDispatcher = injector.getInstance(MessageDispatcher.class);
        this.backgroundTaskManager = injector.getInstance(BackgroundTaskManager.class);
        this.gameInteractionProcessor = injector.getInstance(GameInteractionProcessor.class);
        this.guiContainer = injector.getInstance(GuiContainer.class);
        this.cursorManager = injector.getInstance(CursorManager.class);
        this.i18nTranslator = injector.getInstance(I18nTranslator.class);
        this.screenManager = injector.getInstance(ScreenManager.class);
        this.musicJukebox = injector.getInstance(MusicJukebox.class);
        this.i18nMessageHandler = injector.getInstance(I18nMessageHandler.class);
        this.gameContextRegister = injector.getInstance(GameContextRegister.class);
        this.gameUpdateRegister = injector.getInstance(GameUpdateRegister.class);
        this.gameUpdateRegister.init(injector);
        this.registerGameContextAwareTypes(injector, MapMessageHandler.class, PlantMessageHandler.class, EntityMessageHandler.class, JobMessageHandler.class, DebugMessageHandler.class, DoorwayMessageHandler.class, ConstructionMessageHandler.class, ConstructionStore.class, WorldLightingRenderer.class, MainGameScreen.class, PrimaryCameraWrapper.class, GameWorldInputHandler.class, GameInteractionProcessor.class, EntitySelectedGuiView.class);
        this.screenManager.init(injector);
        this.messageDispatcher.dispatchMessage(2, (Object)GameScreen.MAIN_MENU);
        this.messageDispatcher.dispatchMessage(290);
        this.messageDispatcher.dispatchMessage(291);
    }

    private void registerGameContextAwareTypes(Injector injector, Class<? extends GameContextAware> ... implementations) {
        for (Class<? extends GameContextAware> implementationType : implementations) {
            if (this.gameContextRegister.isRegistered(implementationType)) continue;
            this.gameContextRegister.register(injector.getInstance(implementationType));
        }
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.4f, 0.4f, 0.4f, 1.0f);
        Gdx.gl.glClear(16384);
        float deltaTime = Math.min(Gdx.graphics.getDeltaTime(), 0.06666667f);
        this.messageDispatcher.update();
        this.screenManager.getCurrentScreen().render(deltaTime);
        this.musicJukebox.update();
    }

    @Override
    public void resize(int width, int height) {
        this.primaryCameraWrapper.onResize(width, height);
        this.debugWindow.onResize(width, height);
        this.gameRenderer.onResize(width, height);
        this.guiContainer.onResize(width, height);
        this.screenManager.onResize(width, height);
    }
}

